<?php
    // These PHP variables are assumed to be defined and populated from your backend.
    // They are left here for context, but the styling will be applied to their rendered output.
    $wl = getWhiteLabel();
    $login = getLoginInfo();
    $site_name = $wl && $wl->site_name ? $wl->site_name : 'Your Site Name';
    $site_logo = $wl && $wl->site_logo ? base_url()."uploads/site_settings/".$wl->site_logo : base_url()."assets/images/logo.png";
    $site_favicon = $wl && $wl->site_favicon ? base_url()."uploads/site_settings/".$wl->site_favicon : base_url()."assets/images/favicon.ico";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo escape_output($site_name);?></title>
    <link rel="shortcut icon" href="<?php echo escape_output($site_favicon); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo escape_output($site_favicon); ?>" type="image/x-icon">
    <!-- Tailwind CSS CDN for utility classes -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="<?php echo base_url(); ?>assets/bower_components/jquery/dist/jquery.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/iconify/js/iconify.min.js"></script>
    <style>
        /* Custom CSS for Glassy Effects, Animations, and Overrides */
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            overflow: hidden; /* Prevent scroll due to animated background */
            display: flex;
            flex-direction: column; /* Allow stacking of login card and info display */
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #1a202c 0%, #2d3748 100%); /* Base background */
            color: #e2e8f0; /* Light text color */
        }

        .login-glass-wrap {
            position: relative;
            z-index: 10; /* Ensure it's above the background */
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 1.5rem; /* Responsive padding */
            width: 100%;
            max-width: 640px; /* Increased max width for the wrap */
            margin-bottom: 1.5rem; /* Space between login card and info display */
        }

        .login-glass-card {
            background: rgba(255, 255, 255, 0.05); /* More subtle transparency */
            border-radius: 25px; /* More rounded */
            border: 1px solid rgba(254, 85, 0, 0.3); /* Subtler Orange border with transparency */
            box-shadow: 0 10px 40px 0 rgba(0, 0, 0, 0.4); /* Deeper shadow */
            backdrop-filter: blur(15px); /* Stronger blur for more glass effect */
            -webkit-backdrop-filter: blur(15px); /* Safari support */
            padding: 2.5rem;
            width: 100%;
            max-width: 580px; /* Increased max width for the card */
            transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1); /* Smoother transition */
            overflow: hidden; /* For potential future effects */
        }

        .login-glass-card:hover {
            box-shadow: 0 15px 60px 0 rgba(0, 0, 0, 0.55);
            transform: translateY(-8px) scale(1.01); /* More pronounced lift */
        }

        .login-logo-img {
            max-height: 90px; /* Slightly larger logo */
            width: auto;
            border-radius: 15px; /* More rounded logo */
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3)); /* Shadow for logo */
        }

        .login-title {
            font-size: 2.5rem; /* Larger title */
            font-weight: 700;
            color: #ffffff;
            text-shadow: 0 3px 6px rgba(0, 0, 0, 0.4);
            letter-spacing: -0.05em; /* Tighter spacing */
        }

        .login-desc {
            font-size: 1rem; /* Slightly larger description */
            color: #a0aec0; /* Lighter grey */
            line-height: 1.6;
            margin-bottom: 2rem; /* More space */
        }

        /* Animated Input Fields */
        .animated-input {
            opacity: 0;
            transform: translateY(25px);
            transition: opacity 0.5s ease-out, transform 0.5s ease-out;
            position: relative;
            margin-bottom: 2rem; /* Increased margin */
            /* Centering specific inputs */
            max-width: 480px; /* Increased max width for inputs */
            margin-left: auto; /* Center horizontally */
            margin-right: auto; /* Center horizontally */
        }

        .animated-input .field-header {
            position: absolute;
            top: -1.3rem;
            left: 0.75rem; /* Align with input text */
            font-size: 0.7rem;
            color: #94a3b8; /* Slate gray */
            background: rgba(255, 255, 255, 0.03);
            padding: 0.15rem 0.6rem;
            border-radius: 7px;
            z-index: 1;
            transform: translateY(15px) scale(0.9); /* Starts hidden/smaller */
            opacity: 0;
            transition: all 0.3s ease;
            letter-spacing: 0.02em;
            display: flex; /* Use flexbox for icon and text alignment */
            align-items: center; /* Vertically center icon and text */
        }

        /* Styles for the header icons (inside field-header) */
        .animated-input .field-header .header-icon {
            margin-right: 0.4rem; /* Space between icon and text */
            font-size: 0.8rem; /* Slightly larger than field-header text */
            color: inherit; /* Inherit color from field-header */
            vertical-align: middle; /* Align with text */
            display: inline-block; /* To allow vertical-align */
        }

        .animated-input .form-label {
            position: absolute;
            top: 0.9rem;
            left: 3rem; /* Adjust for icon */
            color: #a0aec0;
            pointer-events: none;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            font-size: 1.05rem;
            z-index: 2;
        }

        .animated-input .input-icon {
            position: absolute;
            left: 1rem;
            top: 0.9rem;
            color: #a0aec0;
            font-size: 1.35rem;
            z-index: 3;
        }

        .animated-input .login-input {
            width: 100%; /* Still 100% of its parent (which is now max-width 480px) */
            padding: 0.9rem 0.9rem 0.9rem 3rem; /* Left padding for icon */
            background: rgba(255, 255, 255, 0.08); /* Slightly more opaque */
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 15px; /* More rounded input */
            color: #fff;
            font-size: 1.05rem;
            transition: all 0.3s ease;
            outline: none;
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.2);
        }

        .animated-input .login-input::placeholder {
            color: rgba(255, 255, 255, 0.3);
        }

        .animated-input .login-input:focus {
            border-color: rgba(254, 85, 0, 0.5); /* Orange focus border - subtler */
            box-shadow: 0 0 0 4px rgba(254, 85, 0, 0.2); /* Subtler shadow */
            background: rgba(255, 255, 255, 0.12);
        }

        /* Input field animation on focus/filled */
        .animated-input .login-input:focus + .form-label,
        .animated-input .login-input:not(:placeholder-shown) + .form-label {
            top: -1.3rem; /* Move label up */
            left: 0.75rem; /* Align with input text */
            font-size: 0.7rem;
            color: rgba(254, 85, 0, 0.5); /* Orange color for active label - subtler */
            background: transparent;
            padding: 0;
            transform: translateY(0) scale(1);
        }

        /* The field-header (with icon inside) animates based on input focus/fill */
        .animated-input .login-input:focus ~ .field-header,
        .animated-input .login-input:not(:placeholder-shown) ~ .field-header {
            opacity: 1;
            transform: translateY(0) scale(1);
            color: rgba(254, 85, 0, 0.5); /* Match active label color for consistency - subtler */
        }

        .animated-input .input-desc {
            font-size: 0.75rem;
            color: #94a3b8;
            margin-top: 0.35rem;
            padding-left: 3rem;
            transition: opacity 0.3s ease; /* For fading out when hint appears */
        }

        .animated-input .field-hint {
            position: absolute;
            bottom: -0.8rem; /* Position below the input */
            left: 3rem; /* Align with input text */
            font-size: 0.75rem;
            color: rgba(255, 124, 43, 0.8); /* Subtler orange hint text */
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.3s ease, transform 0.3s ease;
            pointer-events: none; /* Do not block clicks */
        }

        .form-error {
            color: #ef4444;
            font-size: 0.8rem;
            margin-top: 0.35rem;
            padding-left: 3rem;
        }

        /* Password toggle button */
        .toggle-password {
            position: absolute;
            right: 1rem;
            top: 0.8rem;
            background: none;
            border: none;
            color: #a0aec0;
            font-size: 1.35rem;
            cursor: pointer;
            padding: 0.2rem;
            border-radius: 50%;
            transition: color 0.3s ease, background-color 0.3s ease;
            z-index: 4;
        }
        .toggle-password:hover {
            color: #fff;
            background-color: rgba(255, 255, 255, 0.15);
        }

        /* Links */
        .forgot-link {
            color: rgba(254, 85, 0, 0.5); /* Subtler Orange link */
            text-decoration: none;
            font-size: 0.95rem;
            transition: color 0.3s ease, text-shadow 0.3s ease;
        }
        .forgot-link:hover {
            color: rgba(254, 85, 0, 0.8); /* Darker orange on hover */
            text-shadow: 0 0 8px rgba(254, 85, 0, 0.4); /* Subtler shadow */
        }

        /* Login Button */
        .login-btn {
            background: linear-gradient(90deg, rgba(254, 85, 0, 0.6) 0%, rgba(254, 120, 0, 0.7) 100%); /* Subtler Orange gradient */
            color: #fff;
            padding: 0.9rem 1.8rem;
            border-radius: 15px; /* More rounded button */
            font-size: 1.2rem;
            font-weight: 600;
            border: none;
            cursor: pointer;
            /* Removed box-shadow for glow */
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            position: relative;
            overflow: hidden; /* Crucial for swoosh effect */
            letter-spacing: 0.05em;
            text-transform: uppercase;
            /* Centering specific button */
            max-width: 240px; /* Reduced by 50% from 480px */
            margin-left: auto; /* Center horizontally */
            margin-right: auto; /* Center horizontally */
            display: block; /* Ensure it behaves as a block element for margin auto */
            z-index: 1; /* Ensure pseudo-element is behind */
        }

        /* Swoosh effect for login button */
        .login-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: all 0.5s ease;
            transform: skewX(-20deg); /* Creates a slanted swoosh */
            z-index: 0; /* Behind the text */
        }

        .login-btn:hover::before {
            left: 100%; /* Moves swoosh across */
        }

        .login-btn:hover {
            transform: translateY(-5px) scale(1.03);
            box-shadow: 0 4px 15px rgba(254, 85, 0, 0.4); /* Subtler shadow on hover */
            background: linear-gradient(90deg, rgba(254, 120, 0, 0.7) 0%, rgba(254, 85, 0, 0.6) 100%); /* Invert gradient on hover */
        }

        .login-btn:active {
            transform: translateY(0) scale(0.98);
            box-shadow: 0 2px 10px rgba(254, 85, 0, 0.3); /* Subtler shadow on active */
        }

        /* Repel button effects */
        .login-btn.repel {
            transition: all 0.1s ease-out;
        }
        .login-btn.shrink {
            transform: scale(0.85); /* More shrink */
        }

        /* Info Display Section */
        .info-display-card {
            position: relative;
            z-index: 10;
            background: rgba(255, 255, 255, 0.02); /* More subtle background */
            border-radius: 15px;
            border: 1px solid rgba(255, 255, 255, 0.05); /* Lighter border */
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); /* More subtle shadow */
            backdrop-filter: blur(5px); /* Less blur */
            -webkit-backdrop-filter: blur(5px);
            padding: 1rem 1.5rem;
            color: #a0aec0; /* Slightly darker text for subtlety */
            font-size: 0.85rem;
            text-align: center;
            max-width: 500px; /* Adjust width as needed */
            width: 100%;
            margin-top: 1.5rem; /* Space from login card */
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
            transition: all 0.3s ease; /* Smooth transition for hover */
        }
        .info-display-card:hover {
            background: rgba(255, 255, 255, 0.03); /* Slightly more visible on hover */
            border-color: rgba(255, 255, 255, 0.08);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        .info-display-card .info-header {
            font-size: 1rem;
            font-weight: 600;
            color: #e2e8f0;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        .info-display-card .info-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        .info-display-card .info-item .iconify {
            font-size: 1.1rem;
            color: #ff7c2b; /* Orange accent for icons */
        }
        .info-display-card p {
            margin: 0;
            padding: 0;
            line-height: 1.4;
        }
        .info-display-card strong {
            color: #e2e8f0;
            font-weight: 500;
        }
        .info-display-card .loading-text {
            color: #94a3b8;
        }
        /* Removed .line-graph-svg and its animations */


        /* Toast Notification Styling */
        #customToastContainer {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 10px;
            pointer-events: none; /* Allow clicks to pass through container */
            width: 100%;
            max-width: 400px;
            align-items: center;
        }

        .custom-toast {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            padding: 12px 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 0.95rem;
            color: #e2e8f0;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            opacity: 0;
            transform: translateY(-20px);
            animation: slideInToast 0.5s forwards cubic-bezier(0.25, 0.8, 0.25, 1);
            pointer-events: auto; /* Allow clicks on the toast itself */
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .custom-toast.success {
            background: rgba(16, 185, 129, 0.2); /* Green-500 with transparency */
            border-color: rgba(16, 185, 129, 0.4);
        }

        .custom-toast.error {
            background: rgba(239, 68, 68, 0.2); /* Red-500 with transparency */
            border-color: rgba(239, 68, 68, 0.4);
        }

        .custom-toast .iconify {
            font-size: 1.5rem;
        }

        @keyframes slideInToast {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes fadeOutToast {
            from { opacity: 1; transform: translateY(0); }
            to { opacity: 0; transform: translateY(-20px); }
        }

        /* Responsive adjustments */
        @media (max-width: 640px) {
            .login-glass-card {
                padding: 1.5rem;
                margin: 1rem;
                border-radius: 20px;
                max-width: 90%; /* Allow card to take more width on small screens */
            }
            .login-title {
                font-size: 2rem;
            }
            .login-desc {
                font-size: 0.9rem;
                margin-bottom: 1.5rem;
            }
            .animated-input {
                margin-bottom: 1.5rem;
                max-width: 90%; /* Allow inputs to take more width relative to card */
            }
            .login-btn {
                font-size: 1.1rem;
                padding: 0.8rem 1.2rem;
                max-width: 180px; /* Adjusted for 50% reduction on small screens */
            }
            .info-display-card {
                margin-left: 1rem;
                margin-right: 1rem;
                max-width: 90%;
            }
            #customToastContainer {
                max-width: 90%;
            }
        }
    </style>
</head>
<body class="bg-gradient-to-br from-[#1a202c] to-[#2d3748]">
    <!-- Custom Toast Notification Container -->
    <div id="customToastContainer"></div>

    <div class="login-glass-wrap">
        <div class="login-glass-card">
            <div class="login-logo text-center mb-8">
                <img src="<?php echo $site_logo; ?>" alt="site-logo" class="login-logo-img mx-auto">
            </div>
            <h2 class="login-title mb-3 text-center" id="loginTitle"><?php echo lang('please_login');?></h2>
            <div class="login-desc text-center mb-6" id="loginDesc">
                Welcome. Please log in to access your dashboard. For assistance, kindly contact support.
            </div>
            <?php echo form_open(base_url() . 'Authentication/loginCheck', ['autocomplete' => 'off', 'class' => 'login-form', 'id' => 'dopeLoginForm']) ?>
                <input type="hidden" name="submit" value="submit">
                <div class="form-group animated-input">
                    <div class="field-header">
                        <span class="header-icon iconify" data-icon="solar:user-broken"></span> Username / Email
                    </div>
                    <label for="email_address" class="form-label">Email / Phone</label>
                    <span class="input-icon"><span class="iconify" data-icon="solar:letter-broken"></span></span>
                    <input type="text" class="login-input" id="email_address" name="email_address" placeholder=" " required autocomplete="off">
                    <div class="input-desc" id="emailDesc">Just type it already, champ!</div>
                    <div class="field-hint" id="emailHint">Start with here...</div>
                    <?php if (form_error('email_address')): ?>
                        <div class="form-error"><?php echo form_error('email_address'); ?></div>
                    <?php endif; ?>
                </div>
                <div class="form-group animated-input">
                    <div class="field-header">
                        <span class="header-icon iconify" data-icon="solar:lock-password-broken"></span> Password
                    </div>
                    <label for="password" class="form-label">Password</label>
                    <span class="input-icon"><span class="iconify" data-icon="solar:lock-password-broken"></span></span>
                    <input type="password" class="login-input" id="password" name="password" placeholder=" " required autocomplete="off">
                    <button type="button" class="toggle-password" tabindex="-1"><span class="iconify" data-icon="solar:eye-closed-broken"></span></button>
                    <div class="input-desc" id="passwordDesc">Your secret handshake, please.</div>
                    <div class="field-hint" id="passwordHint">Then here...</div>
                    <?php if (form_error('password')): ?>
                        <div class="form-error"><?php echo form_error('password'); ?></div>
                    <?php endif; ?>
                </div>
                <div class="flex justify-center items-center mb-8"> <!-- Centered the forgot password link -->
                    <a href="<?php echo base_url()?>forgot-password-step-one" class="forgot-link">Forgot password?</a>
                </div>
                <button type="submit" class="login-btn w-full mb-4" id="dopeLoginBtn"><?php echo lang('login');?></button>
            <?php echo form_close(); ?>
            <?php /* Removed the demo-links section as requested */ ?>
        </div> <!-- end of .login-glass-card -->
    </div> <!-- end of .login-glass-wrap -->

    <!-- Info Display Section -->
    <div class="info-display-card">
        <div class="info-header" id="infoSectionHeader"><span class="iconify" data-icon="solar:chart-line-up-broken"></span> System Info</div>
        <div class="info-item">
            <span class="iconify" data-icon="solar:clock-broken"></span>
            <p>Current Time: <strong id="currentTime">Loading...</strong></p>
        </div>
        <div class="info-item">
            <span class="iconify" data-icon="solar:globe-broken"></span>
            <p>Public IP: <strong id="publicIp">Loading...</strong></p>
        </div>
        <div class="info-item">
            <span class="iconify" data-icon="solar:laptop-broken"></span>
            <p>Device Info: <strong id="deviceInfo">Loading...</strong></p>
        </div>
        <?php /* Removed the line graph SVG as requested */ ?>
    </div>

    <script>
        // Function to decode text like an alien/scrambled effect
        function decodeText(elementId, originalText, delay = 0) {
            const element = document.getElementById(elementId);
            if (!element) {
                console.warn(`Element with ID '${elementId}' not found for decodeText.`);
                return;
            }

            const scrambledChars = "!@#$%^&*()_+{}[]|:;\"'<>,.?/~";
            let revealIndex = 0;
            let interval;

            setTimeout(() => {
                // Immediately scramble the entire text to make the effect visible from the start
                let initialScrambledText = '';
                for (let i = 0; i < originalText.length; i++) {
                    initialScrambledText += scrambledChars[Math.floor(Math.random() * scrambledChars.length)];
                }
                element.textContent = initialScrambledText; // Set to scrambled immediately

                interval = setInterval(() => {
                    let tempText = '';
                    for (let i = 0; i < originalText.length; i++) {
                        if (i < revealIndex) {
                            tempText += originalText[i];
                        } else {
                            tempText += scrambledChars[Math.floor(Math.random() * scrambledChars.length)];
                        }
                    }

                    element.textContent = tempText;

                    if (revealIndex >= originalText.length) {
                        clearInterval(interval);
                        element.textContent = originalText; // Ensure final text is exact
                    }
                    revealIndex++;
                }, 20); // Speed of decoding (milliseconds per character reveal step - shorter)
            }, delay);
        }

        // Custom Toast Notification Function
        function showToast(message, type = 'info') {
            const container = document.getElementById('customToastContainer');
            const toast = document.createElement('div');
            toast.classList.add('custom-toast', type);

            let icon = '';
            // Added more fun messages and emojis for toast
            if (type === 'success') {
                icon = '<span class="iconify" data-icon="solar:check-circle-broken"></span>';
                const successMessages = [
                    "You nailed it! 🎉",
                    "Success! Time to shine! ✨",
                    "Boom! You're in! 🚀",
                    "Perfectly done! 👍"
                ];
                message = successMessages[Math.floor(Math.random() * successMessages.length)];
            } else if (type === 'error') {
                icon = '<span class="iconify" data-icon="solar:danger-triangle-broken"></span>';
                const errorMessages = [
                    "Uh oh! Something's not right. 🧐",
                    "Whoops! Double-check those details. 🤔",
                    "Access Denied! Are you sure you're you? 🕵️‍♀️",
                    "Nope! Try again, buttercup. 😅"
                ];
                message = errorMessages[Math.floor(Math.random() * errorMessages.length)];
            } else {
                icon = '<span class="iconify" data-icon="solar:info-circle-broken"></span>';
            }

            toast.innerHTML = `${icon} <span>${message}</span>`;
            container.appendChild(toast);

            // Trigger reflow to ensure animation plays
            void toast.offsetWidth;

            toast.style.animation = 'slideInToast 0.5s forwards cubic-bezier(0.25, 0.8, 0.25, 1)';

            setTimeout(() => {
                toast.style.animation = 'fadeOutToast 0.5s forwards cubic-bezier(0.25, 0.8, 0.25, 1)';
                toast.addEventListener('animationend', () => {
                    toast.remove();
                }, { once: true });
            }, 5000); // Toast visible for 5 seconds
        }

        // Show/hide password toggle
        $(document).on('click', '.toggle-password', function(){
            var input = $('#password');
            var icon = $(this).find('.iconify');
            if(input.attr('type') === 'password'){
                input.attr('type', 'text');
                icon.attr('data-icon', 'solar:eye-broken');
            } else {
                input.attr('type', 'password');
                icon.attr('data-icon', 'solar:eye-closed-broken');
            }
        });

        // Animate input entry on page load
        $(document).ready(function(){
            $('.animated-input').each(function(i, el){
                setTimeout(function(){ $(el).css({opacity:1, transform:'none'}); }, 120 + i*120);
            });

            // Handle PHP flashdata with custom toast
            <?php if ($this->session->flashdata('exception_1')): ?>
                showToast("<?php echo addslashes($this->session->flashdata('exception_1')); ?>", 'error');
            <?php endif; ?>
            <?php if ($this->session->flashdata('exception')): ?>
                showToast("<?php echo addslashes($this->session->flashdata('exception')); ?>", 'success');
            <?php endif; ?>

            // Store original texts for decoding effect
            const originalLoginTitle = $('#loginTitle').text();
            // Apply decode effect to title only
            decodeText('loginTitle', originalLoginTitle, 100);

            // Functions for Info Display - now with decoding
            function updateTimeAndDecode() {
                const now = new Date();
                const options = { hour: '2-digit', minute: '2-digit', second: '2-digit', hour12: true };
                const timeString = now.toLocaleTimeString('en-US', options);
                decodeText('currentTime', timeString, 0); // Decode immediately when updated
            }

            async function fetchPublicIpAndDecode() {
                try {
                    const response = await fetch('https://api.ipify.org?format=json');
                    const data = await response.json();
                    decodeText('publicIp', data.ip || 'N/A', 100); // Decode after fetching
                } catch (error) {
                    console.error('Error fetching IP:', error);
                    decodeText('publicIp', 'Failed to load', 100); // Decode error message
                }
            }

            function displayDeviceInfoAndDecode() {
                decodeText('deviceInfo', navigator.userAgent, 200); // Decode immediately
            }

            // Apply alien effect to the entire info-display-card content
            // Store original texts for info display elements for decoding effect
            const originalInfoHeader = $('#infoSectionHeader').text();
            const originalCurrentTime = $('#currentTime').text();
            const originalPublicIp = $('#publicIp').text();
            const originalDeviceInfo = $('#deviceInfo').text();

            // Apply decode effect to info display elements
            decodeText('infoSectionHeader', originalInfoHeader, 300); // Header first
            decodeText('currentTime', originalCurrentTime, 400); // Then time
            decodeText('publicIp', originalPublicIp, 500); // Then IP
            decodeText('deviceInfo', originalDeviceInfo, 600); // Then device info

            // Update time every second (will re-decode each time)
            setInterval(updateTimeAndDecode, 1000);
            // Fetch IP and device info once on load (will decode once)
            fetchPublicIpAndDecode();
            displayDeviceInfoAndDecode();

            // Initial check for repel button and hints on load
            updateRepelButtonAndHints();
        });

        // Repelled login button logic (modernized)
        function isLoginFieldsFilled() {
            return $("#email_address").val().trim() !== '' && $("#password").val().trim() !== '';
        }

        // Function to update repel button state and hints
        function updateRepelButtonAndHints() {
            const emailFieldEmpty = $("#email_address").val().trim() === '';
            const passwordFieldEmpty = $("#password").val().trim() === '';
            const loginButton = $('#dopeLoginBtn');

            if (emailFieldEmpty || passwordFieldEmpty) {
                loginButton.addClass('repel shrink');
                loginButton.text('❌ Fill the fields!'); // Set initial text
                // Show hints, hide descriptions
                if (emailFieldEmpty) {
                    $('#emailDesc').css('opacity', 0);
                    $('#emailHint').css({opacity: 1, transform: 'translateY(0)'});
                } else {
                    $('#emailDesc').css('opacity', 1);
                    $('#emailHint').css({opacity: 0, transform: 'translateY(10px)'});
                }

                if (passwordFieldEmpty) {
                    $('#passwordDesc').css('opacity', 0);
                    $('#passwordHint').css({opacity: 1, transform: 'translateY(0)'});
                } else {
                    $('#passwordDesc').css('opacity', 1);
                    $('#passwordHint').css({opacity: 0, transform: 'translateY(10px)'});
                }
            } else {
                loginButton.removeClass('repel shrink').css({left:'0', top:'0'});
                loginButton.text('<?php echo lang('login');?>'); // Reset text
                // Hide hints, show descriptions
                $('#emailDesc').css('opacity', 1);
                $('#emailHint').css({opacity: 0, transform: 'translateY(10px)'});
                $('#passwordDesc').css('opacity', 1);
                $('#passwordHint').css({opacity: 0, transform: 'translateY(10px)'});
            }
        }

        let evadeTries = 0;
        let lastMove = {x: 0, y: 0};
        $(document).on('mousemove', '#dopeLoginBtn', function(e) {
            if (!isLoginFieldsFilled()) {
                evadeTries++;
                let btn = $(this);
                let parent = btn.parent();
                let parentOffset = parent.offset();
                let btnWidth = btn.outerWidth();
                let btnHeight = btn.outerHeight();
                let parentWidth = parent.width();
                let parentHeight = parent.height();
                let mouseX = e.pageX - parentOffset.left;
                let mouseY = e.pageY - parentOffset.top;
                // Calculate center of button
                let btnLeft = btn.position().left;
                let btnTop = btn.position().top;
                let btnCenterX = btnLeft + btnWidth/2;
                let btnCenterY = btnTop + btnHeight/2;
                // Vector from mouse to button center
                let dx = btnCenterX - mouseX;
                let dy = btnCenterY - mouseY;
                let dist = Math.sqrt(dx*dx + dy*dy);
                let repelDist = 100; // Increased repel distance for stronger "magnet" effect

                // Show/hide hints based on field emptiness
                updateRepelButtonAndHints(); // Call this to manage hints during mousemove

                if(dist < repelDist) {
                    // Move button away from cursor
                    let angle = Math.atan2(dy, dx);
                    let moveX = Math.cos(angle) * (repelDist - dist);
                    let moveY = Math.sin(angle) * (repelDist - dist);
                    let newLeft = Math.min(Math.max(btnLeft + moveX, 0), parentWidth - btnWidth);
                    let newTop = Math.min(Math.max(btnTop + moveY, 0), parentHeight - btnHeight);
                    btn.addClass('repel shrink');
                    btn.css({position:'relative', left: newLeft + 'px', top: newTop + 'px'});
                    lastMove = {x: newLeft, y: newTop};
                }
                // Changed text for repel button when fields are empty
                if(evadeTries > 6) btn.text('❌ Fill the fields!');
            } else {
                $(this).removeClass('repel shrink').css({left:'0', top:'0'});
                evadeTries = 0;
                updateRepelButtonAndHints(); // Ensure hints are hidden when fields are filled
            }
        });
        $(document).on('mouseleave', '#dopeLoginBtn', function(){
            $(this).removeClass('repel shrink').css({left:'0', top:'0'});
            updateRepelButtonAndHints(); // Ensure hints are hidden when mouse leaves button
        });
        $(document).on('input', '#email_address, #password', function(){
            if(isLoginFieldsFilled()) {
                $('#dopeLoginBtn').removeClass('repel shrink').css({left:'0', top:'0'}).text('<?php echo lang('login');?>');
            }
            updateRepelButtonAndHints(); // Update hint visibility on input change
        });
    </script>
</body>
</html>
