<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!-- Top Navigation -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary top-navbar">
    <div class="container-fluid">
        <!-- Logo/Brand -->
        <a class="navbar-brand" href="<?php echo base_url(); ?>Dashboard/dashboard">
            <img src="<?php echo $site_logo; ?>" alt="<?php echo $site_name; ?>" class="logo-img">
        </a>
        
        <!-- Mobile Toggle Button -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- Main Navigation -->
        <div class="collapse navbar-collapse" id="mainNavbar">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <!-- Dashboard -->
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(); ?>Dashboard/dashboard">
                        <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                    </a>
                </li>

                <!-- Sales Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="salesDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-shopping-cart me-1"></i> Sales
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Sale/POS">POS</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Sale/orders">Orders</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Sale/invoices">Invoices</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Customer/customers">Customers</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Delivery_partner/listPartner">Delivery Partners</a></li>
                    </ul>
                </li>

                <!-- Inventory Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="inventoryDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-boxes me-1"></i> Inventory
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Item/items">Products</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Stock/stock">Stock Management</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Category/categories">Categories</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Brand/brands">Brands</a></li>
                    </ul>
                </li>

                <!-- Procurement Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="procurementDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-shopping-basket me-1"></i> Procurement
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Purchase/purchases">Purchases</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Supplier/suppliers">Suppliers</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Purchase/returnPurchases">Purchase Returns</a></li>
                    </ul>
                </li>

                <!-- Accounting Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="accountingDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-calculator me-1"></i> Accounting
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Account/accounts">Accounts</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Transaction/transactions">Transactions</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>PaymentMethod/paymentMethods">Payment Methods</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Expense/expenses">Expenses</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Income/incomes">Income</a></li>
                    </ul>
                </li>

                <!-- Reports Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-chart-bar me-1"></i> Reports
                    </a>
                    <ul class="dropdown-menu">
                        <li><h6 class="dropdown-header">Sales Reports</h6></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/salesReport">Sales Summary</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/salesByItem">Sales by Item</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/salesByCustomer">Sales by Customer</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><h6 class="dropdown-header">Inventory Reports</h6></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/stockReport">Stock Report</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/lowStockReport">Low Stock</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Report/financialReport">Financial Report</a></li>
                    </ul>
                </li>
            </ul>

            <!-- Right Side Navigation -->
            <ul class="navbar-nav ms-auto">
                <!-- Search -->
                <li class="nav-item search-nav-item">
                    <div class="search-box">
                        <input type="text" class="form-control" placeholder="Search...">
                        <button class="btn btn-search"><i class="fas fa-search"></i></button>
                    </div>
                </li>

                <!-- Notifications -->
                <li class="nav-item dropdown">
                    <a class="nav-link" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="far fa-bell"></i>
                        <span class="badge bg-danger rounded-pill">3</span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end notification-dropdown">
                        <li><h6 class="dropdown-header">Notifications</h6></li>
                        <li><a class="dropdown-item" href="#">New order received</a></li>
                        <li><a class="dropdown-item" href="#">Low stock alert</a></li>
                        <li><a class="dropdown-item" href="#">System update available</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center" href="#">View all notifications</a></li>
                    </ul>
                </li>

                <!-- User Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle user-menu" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <img src="<?php echo base_url('assets/img/avatar.png'); ?>" class="rounded-circle me-1" width="30" alt="User">
                        <span class="d-none d-md-inline"><?php echo $this->session->userdata('full_name'); ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Authentication/userProfile"><i class="fas fa-user me-2"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Authentication/changePassword"><i class="fas fa-key me-2"></i> Change Password</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo base_url(); ?>Authentication/logout"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
