<style>
/* Soft Dark Neumorphism (Morphism) UI Enhancements - Updated (copied from roles/users/items/rack/unit/itemCategory/variation/brand list) */
body, .main-content-wrapper {
    background: #23272f !important;
    color: #fff !important;
}
.main-content-wrapper {
    min-height: 100vh;
    padding: 32px 0 0 0;
    background: #23272f !important;
}
.box-wrapper {
    background: #23272f;
    border-radius: 6px;
    box-shadow: 8px 8px 24px #1a1d22, -8px -8px 24px #2c313a;
    padding: 32px 24px 24px 24px;
    margin-top: 24px;
    color: #fff;
}
.table-box {
    background: #23272f;
    border-radius: 6px;
    box-shadow: 4px 4px 16px #1a1d22, -4px -4px 16px #2c313a;
    padding: 16px;
    color: #fff;
}
table.table {
    background: #23272f;
    color: #fff;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
table.table thead {
    background: linear-gradient(90deg, rgb(77,62,82) 0%, #232b33 100%);
    border-top-left-radius: 6px;
    border-top-right-radius: 6px;
}
table.table thead th {
    color: #fff !important;
    background: transparent !important;
    font-weight: 600;
    font-size: 1.05rem;
    border: none;
}
table.table tbody tr {
    background: #23272f;
    transition: background 0.2s;
    color: #fff;
}
table.table tbody tr:nth-of-type(odd) {
    background-color: #23272f;
}
table.table tbody tr:nth-of-type(even) {
    background-color: #232b33;
}
table.table tbody tr:hover {
    background: #31353f;
}
table.table td, table.table th {
    border: none !important;
    color: #fff;
}
.btn_group_wrap a.btn {
    border-radius: 6px;
    background: #23272f;
    color: #fff;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    border: none;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
    margin-right: 6px;
    padding: 6px 14px;
    font-size: 1rem;
}
.btn_group_wrap a.btn:hover {
    background: #31353f;
    color: #fff;
    box-shadow: 0 0 0 2px #4F46E5, 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.btn_list .new-btn {
    border-radius: 6px;
    background: linear-gradient(145deg, #23272f 60%, #2c313a 100%);
    color: #fff;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    border: none;
    padding: 8px 20px;
    font-size: 1.08rem;
    font-weight: 500;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
}
.btn_list .new-btn:hover {
    background: #4F46E5;
    color: #fff;
    box-shadow: 0 0 0 2px #4F46E5, 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.content-header {
    background: linear-gradient(90deg, #31353f 0%, #232b33 100%);
    border-radius: 6px;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    padding: 24px 24px 16px 24px;
    margin-bottom: 24px;
}
.content-header h3.top-left-header {
    color: #fff;
    text-shadow: 1px 1px 4px #1a1d22;
    background: linear-gradient(90deg, #4F46E5 0%, #232b33 100%);
    border-radius: 6px;
    padding: 8px 24px;
    display: inline-block;
    box-shadow: 1px 1px 6px #1a1d22;
}
.alert-wrapper .alert {
    background: #2c313a;
    color: #fff;
    border-radius: 6px;
    border: none;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.exportDropdown .toggleBtn {
    background: #fe5500 !important;
    color: #fff !important;
    border: 2px double #fff;
    border-radius: 4px;
    padding: 10px 28px 10px 18px;
    font-size: 1.08rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    position: relative;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    transition: background 0.2s, color 0.2s;
    overflow: hidden;
}
.exportDropdown .toggleBtn span, .exportDropdown .toggleBtn svg {
    color: #fff !important;
    fill: #fff !important;
}
.exportDropdown .toggleBtn svg.feather-share {
    margin-right: 8px;
    color: #fff;
}
.exportDropdown .toggleBtn:hover {
    background: #232323;
    color: #fff;
}
.exportDropdown .toggleBtn::after {
    content: '';
    display: block;
    position: absolute;
    left: -40%;
    top: 0;
    width: 60%;
    height: 100%;
    background: linear-gradient(120deg, rgba(255,255,255,0.18) 0%, rgba(255,255,255,0.04) 100%);
    transform: skewX(-20deg) translateX(-100%);
    transition: transform 0.5s cubic-bezier(.4,2,.6,1);
    pointer-events: none;
}
.exportDropdown .toggleBtn:hover::after {
    transform: skewX(-20deg) translateX(120%);
}
</style>
<div class="main-content-wrapper">
<?php
if ($this->session->flashdata('exception')) {
    echo '<section class="alert-wrapper"><div class="alert alert-success alert-dismissible fade show"> 
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-hidden="true"></button>
    <div class="alert-body"><i class="icon fa fa-check me-2"></i>';
    echo escape_output($this->session->flashdata('exception'));unset($_SESSION['exception']);
    echo '</div></div></section>';
}
?> 
    <section class="content-header">
        <div class="row justify-content-between">
            <div class="col-6 p-0">
                <h3 class="top-left-header"><?php echo lang('list_purchase'); ?> </h3>
                <input type="hidden" class="datatable_name" data-title="<?php echo lang('list_purchase'); ?>" data-id_name="datatable">
                <div class="btn_list m-right d-flex">
                    <a class="new-btn me-1" href="<?php echo base_url() ?>Purchase/addEditPurchase">
                    <iconify-icon icon="solar:add-circle-broken" width="22"></iconify-icon> <?php echo lang('add_purchase'); ?>
                    </a>
                    <button type="button" class="dataFilterBy new-btn"><iconify-icon icon="solar:filter-broken"  width="22"></iconify-icon> <?php echo lang('filter_by');?></button>
                </div>
                
            </div>
            <?php $this->view('updater/breadcrumb', ['firstSection'=> lang('purchase'), 'secondSection'=> lang('list_purchase')])?>
        </div>
    </section>

    <div class="box-wrapper">
        <div class="table-box"> 
            <!-- /.box-header -->
            <div class="table-responsive"> 
                <table id="datatable" class="table table-responsive table-bordered table-striped purchase_ajax_page">
                    <thead>
                        <tr>
                            <th class="w-5"><?php echo lang('sn'); ?></th>
                            <th class="w-10"><?php echo lang('ref_no'); ?></th>
                            <th class="w-10"><?php echo lang('invoice_no'); ?></th>
                            <th class="w-8"><?php echo lang('date'); ?></th>
                            <th class="w-10"><?php echo lang('supplier'); ?></th>
                            <th class="w-9"><?php echo lang('g_total'); ?></th>
                            <th class="w-9"><?php echo lang('paid'); ?></th>
                            <th class="w-9"><?php echo lang('due'); ?></th>
                            <th class="w-10"><?php echo lang('added_by'); ?></th>
                            <th class="w-10"><?php echo lang('added_date'); ?></th>
                            <th class="w-5"><?php echo lang('actions'); ?></th>
                        </tr>
                    </thead>
                    </tbody>
                </table>
            </div>
            <!-- /.box-body -->
        </div> 
    </div>
</div>


<div class="modal fade" id="barcode_print">
    <div class="modal-dialog modal-lg" role="barcode_print">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><span class="item_name"><?php echo lang('print_barcode');?></span></h4>
                <button type="button" class="btn-close m_close_trigger" data-bs-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true"><i data-feather="x"></i></span></button>
            </div>
            <div class="modal-body">
                <div class="row mt-3" id="barcode_wrap">
                </div>
            </div>
            <div class="modal-footer">
                <a  class="btn bg-blue-btn" id="print_barcode_wrap"><?php echo lang('Print');?></a>
            </div>
        </div>
    </div>
</div>


<div class="filter-overlay"></div>
<div id="product-filter" class="filter-modal">
    <div class="filter-modal-body">
        <header>
                <h3 class="filter-modal-title"><span><?php echo lang('FilterOptions'); ?></span></h3>
                <button type="button" class="close-filter-modal" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">
                        <i data-feather="x"></i>
                    </span>
                </button>
        </header>
        <?php echo form_open(base_url() . 'Purchase/purchases') ?>
        <div class="row">
            <div class="col-sm-12 col-md-6 mb-2">
                <div class="form-group">
                    <input  autocomplete="off" type="text" id="startDate" name="startDate" readonly class="form-control customDatepicker" placeholder="<?php echo lang('start_date'); ?>" value="<?php echo isset($_POST['startDate']) && $_POST['startDate'] ? $_POST['startDate'] : '' ?>">
                </div>
                <div class="alert alert-error error-msg startDate_err_msg_contnr ">
                    <p id="startDate_err_msg"></p>
                </div>
            </div>
            <div class="col-sm-12 col-md-6 mb-2">
                <div class="form-group">
                    <input  autocomplete="off" type="text" id="endDate" name="endDate" readonly class="form-control customDatepicker" placeholder="<?php echo lang('end_date'); ?>" value="<?php echo isset($_POST['endDate']) && $_POST['endDate'] ? $_POST['endDate'] : '' ?>">
                </div>
                <div class="alert alert-error error-msg endDate_err_msg_contnr ">
                    <p id="endDate_err_msg"></p>
                </div>
            </div>
            <div class="col-sm-12 col-md-6 mb-2">
                <div class="form-group">
                    <select name="supplier_id" id="supplier_id" class="form-control select2 width_100_p mx-2">
                        <option value=""><?php echo lang('supplier'); ?></option>
                        <?php foreach ($suppliers as $val) { ?>
                            <option value="<?php echo escape_output($val->id) ?>" <?php echo set_select('supplier_id', $val->id); ?>><?php echo escape_output($val->name) ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <?php
            if(isLMni()):
            ?>
            <div class="col-sm-12 col-md-6 mb-2">
                <div class="form-group">
                    <select  class="form-control select2 ir_w_100" id="outlet_id" name="outlet_id">
                        <?php
                            $role = $this->session->userdata('role');
                            if($role == '1'){
                        ?>
                        <option value=""><?php echo lang('select_outlet') ?></option>
                        <?php } ?>
                        <?php
                        $outlets = getOutletsForReport();
                        foreach ($outlets as $value):
                            ?>
                            <option <?= set_select('outlet_id',$value->id)?>  value="<?php echo escape_output($value->id) ?>"><?php echo escape_output($value->outlet_name) ?></option>
                            <?php
                        endforeach;
                        ?>
                    </select>
                </div>
            </div>
            <?php
                endif;
            ?> 
            <div class="col-sm-12 col-md-6">
                <button type="submit" name="submit" value="submit" class="new-btn">
                    <iconify-icon icon="solar:hourglass-broken" width="22"></iconify-icon>
                    <?php echo lang('submit'); ?>
                </button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>



<?php $this->load->view('updater/reuseJs2')?>
<script src="<?php echo base_url(); ?>frequent_changing/js/purchase.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/barcode/JsBarcode.all.js"></script>
<script src="<?php echo base_url(); ?>frequent_changing/js/purchase_barcode.js"></script>
<script src="<?php echo base_url(); ?>frequent_changing/js/item-barcode-print.js"></script>